/*
 *  Countdown 360 - v0.1.9
 *  This is a simple attractive circular countdown timer that counts down a number of seconds. The style is configurable and callbacks are supported on completion.
 *  https://github.com/johnschult/jquery.countdown360
 *
 *  Made by John Schult
 *  Under MIT License
 */
!function(a,b,c,d){function e(b,c){this.element=b,this.settings=a.extend({},g,c),this.settings.fontSize||(this.settings.fontSize=this.settings.radius/1.2),this.settings.strokeWidth||(this.settings.strokeWidth=this.settings.radius/4),this._defaults=g,this._name=f,this._init()}var f="countdown360",g={radius:15.5,strokeStyle:"#477050",strokeWidth:d,fillStyle:"#8ac575",fontColor:"#477050",fontFamily:"sans-serif",fontSize:d,fontWeight:700,autostart:!0,seconds:10,label:["second","seconds"],startOverAfterAdding:!0,smooth:!1,onComplete:function(){}};e.prototype={getTimeRemaining:function(){var a=this._secondsLeft(this.getElapsedTime());return a},getElapsedTime:function(){return Math.round(((new Date).getTime()-this.startedAt.getTime())/1e3)},extendTimer:function(a){var b=parseInt(a),c=Math.round(((new Date).getTime()-this.startedAt.getTime())/1e3);this._secondsLeft(c)+b<=this.settings.seconds&&this.startedAt.setSeconds(this.startedAt.getSeconds()+parseInt(a))},addSeconds:function(a){var b=Math.round(((new Date).getTime()-this.startedAt.getTime())/1e3);this.settings.startOverAfterAdding?(this.settings.seconds=this._secondsLeft(b)+parseInt(a),this.start()):this.settings.seconds+=parseInt(a)},start:function(){this.startedAt=new Date,this._drawCountdownShape(3.5*Math.PI,!0),this._drawCountdownLabel(0);var a=1e3;this.settings.smooth&&(a=16),this.interval=setInterval(jQuery.proxy(this._draw,this),a)},stop:function(a){clearInterval(this.interval),a&&a()},_init:function(){this.settings.width=2*this.settings.radius+2*this.settings.strokeWidth,this.settings.height=this.settings.width,this.settings.arcX=this.settings.radius+this.settings.strokeWidth,this.settings.arcY=this.settings.arcX,this._initPen(this._getCanvas()),this.settings.autostart&&this.start()},_getCanvas:function(){var b=a('<canvas id="countdown360_'+a(this.element).attr("id")+'" width="'+this.settings.width+'" height="'+this.settings.height+'"><span id="countdown-text" role="status" aria-live="assertive"></span></canvas>');return a(this.element).prepend(b[0]),b[0]},_initPen:function(b){this.pen=b.getContext("2d"),this.pen.lineWidth=this.settings.strokeWidth,this.pen.strokeStyle=this.settings.strokeStyle,this.pen.fillStyle=this.settings.fillStyle,this.pen.textAlign="center",this.pen.textBaseline="middle",this.ariaText=a(b).children("#countdown-text"),this._clearRect()},_clearRect:function(){this.pen.clearRect(0,0,this.settings.width,this.settings.height)},_secondsLeft:function(a){return this.settings.seconds-a},_drawCountdownLabel:function(a){this.ariaText.text(b),this.pen.font=this.settings.fontWeight+" "+this.settings.fontSize+"px "+this.settings.fontFamily;var b=this._secondsLeft(a),c=1===b?this.settings.label[0]:this.settings.label[1],d=this.settings.label&&2===this.settings.label.length,e=this.settings.width/2;y=d?this.settings.height/2-this.settings.fontSize/6.2:this.settings.height/2,this.pen.fillStyle=this.settings.fillStyle,this.pen.fillText(b+1,e,y),this.pen.fillStyle=this.settings.fontColor,this.pen.fillText(b,e,y),d&&(this.pen.font="normal small-caps "+this.settings.fontSize/3+"px "+this.settings.fontFamily,this.pen.fillText(c,this.settings.width/2,this.settings.height/2+this.settings.fontSize/2.2))},_drawCountdownShape:function(a,b){this.pen.fillStyle=this.settings.fillStyle,this.pen.beginPath(),this.pen.arc(this.settings.arcX,this.settings.arcY,this.settings.radius,1.5*Math.PI,a,!1),this.pen.fill(),b&&this.pen.stroke()},_draw:function(){var a,b;a=(new Date).getTime()-this.startedAt.getTime(),b=Math.floor(a/1e3),endAngle=3.5*Math.PI-2*Math.PI/(1e3*this.settings.seconds)*a,this._clearRect(),this._drawCountdownShape(3.5*Math.PI,!1),b<this.settings.seconds?(this._drawCountdownShape(endAngle,!0),this._drawCountdownLabel(b)):(this._drawCountdownLabel(this.settings.seconds),this.stop(),this.settings.onComplete())}},a.fn[f]=function(b){var c;return this.each(function(){c=a.data(this,"plugin_"+f),c||(c=new e(this,b),a.data(this,"plugin_"+f,c))}),c}}(jQuery,window,document);